public class ExceptionMethods {
    
    /** = the value r that satisfies x = q*y + r and 0  r < y for some q.
     Throw an IllegalArgumentException if y = 0. */
    public static int mod(int x, int y) {
        if (y == 0) {
            throw new IllegalArgumentException("x mod 0 is illegal");
        }
        /* Because q*y = (-q)*(-y), mod(x,y) = mod(x,-y). */
        y= Math.abs(y);
        
        int r= x % y;
        
        /* For x  0, mod(x,y) = x % y */
        if (x >= 0)
            return r;
        
        /* For x < 0: x % y is the value r' that satisfies
         x = q*y + r' and -y < r'  0
         =   <manipulate>
         x = (q-1)*y + (r'+y) and -0 < r'+y  y
         Hence, x mod y is x % y + y */
        return r + y;
    }
    
    /** = the value r that satisfies x = q*y + r and 0  r < y for some q.
          Throw an IllegalArgumentException if y = 0. */
    public static int mod2(int x, int y) {
        try {
            /* Because q*y = (-q)*(-y), mod(x,y) = mod(x,-y). */
            y= Math.abs(y);
            
            int r= x % y;
            
            /* For x  0, mod(x,y) = x % y */
            if (x >= 0)
                return r;
            
            /* For x < 0: x % y is the value r' that satisfies
                  x = q*y + r' and -y < r'  0
               =     <manipulate>
                  x = (q-1)*y + (r'+y) and -0 < r'+y  y
               Hence, x mod y is x % y + y */
            return r + y;
        }
        catch (ArithmeticException ae) {
            throw new IllegalArgumentException("x mod 0 is illegal");
        }
    } 
    
    
    
    
}